import 'reflect-metadata';
import 'zone.js';
import 'bootstrap';
import { enableProdMode } from '@angular/core';
import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { AppModule } from './app/app.module.browser';

if (module.hot) {
    module.hot.accept();
    module.hot.dispose(() => {
        // Przed ponowynm uruchomieniem aplikacji należy utworzyć nowy element główny i pozbyć się starego.
        const oldRootElem = document.querySelector('app');
        const newRootElem = document.createElement('app');
        oldRootElem!.parentNode!.insertBefore(newRootElem, oldRootElem);
        modulePromise.then(appModule => appModule.destroy());
    });
} else {
    enableProdMode();
}

// Uwaga: @ng-tools/webpack szuka następującego wyrażenia podczas kompilacji dla środowiska produkcyjnego.
// Nie zmieniaj tego wiersza, ponieważ możesz uszkodzić aplikację.
const modulePromise = platformBrowserDynamic().bootstrapModule(AppModule);
